

<!DOCTYPE html>
<html lang="en">
<head>
    <title>Easy Money Transfer</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimal-ui">
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <link rel="icon" href="assets/images/favicon.svg" type="image/x-icon">
    <link rel="stylesheet" href="assets/fonts/fontawesome/css/fontawesome-all.min.css">
    <link rel="stylesheet" href="assets/plugins/animation/css/animate.min.css">
    <link rel="stylesheet" href="assets/css/style.css">
</head>

<body>
<!-- [ auth-signin ] start -->
<div class="auth-wrapper">
    <div class="auth-content container">
        <div class="card">
            <div class="row align-items-center">
                <div class="col-md-6">
                    <div class="card-body">
                        <h2 class="text-success">Easy Money Transfer</h2>
                        <h4 class="mb-3 f-w-400 text-primary">Login into Admin Panel</h4>

						<?php
							session_start(); // Start the session
							include '../connection.php';

							// Check connection
							if ($con->connect_error) {
								die("Connection failed: " . $con->connect_error);
							}

							// Handle form submission
							if ($_SERVER["REQUEST_METHOD"] == "POST") {
								$username = $_POST['user'];
								$password = $_POST['password'];

								// Prepare and bind
								$stmt = $con->prepare("SELECT * FROM admin_login WHERE admin_name = ? AND password = ?");
								$stmt->bind_param("ss", $username, $password);
								$stmt->execute();
								$result = $stmt->get_result();

								// Check if user exists
								if ($result->num_rows > 0) {
									// User found, set session variable
									$_SESSION['loggedin'] = true; // Set session variable
									$_SESSION['username'] = $username; // Optionally store the username
									header("Location: AdminHome/index.php");
									exit();
								} else {
									echo "<p class='text-danger'>Invalid username or password.</p>";
								}
								$stmt->close();
							}

							$con->close();
						?>


                        <form action="" method="post">
                            <div class="form-group mb-2">
                                <label class="form-label">Enter Username</label>
                                <input type="text" name="user" class="form-control" placeholder="Username" required>
                            </div>
                            <div class="form-group mb-3">
                                <label class="form-label">Enter Password</label>
                                <input type="password" name="password" class="form-control" placeholder="Password" required>
                            </div>
                            <div class="saprator"><span></span></div>

                            <button class="btn btn-primary mb-4 btf" type="submit">Login</button>
                        </form>
                    </div>
                </div>
                <div class="col-md-6 d-none d-md-block">
                    <img src="assets/images/emt-b.jpeg" alt="" class="img-fluid">
                </div>
            </div>
        </div>
    </div>
</div>
<!-- [ auth-signin ] end -->

<!-- Required Js -->
<script src="assets/js/vendor-all.min.js"></script>
<script src="assets/plugins/bootstrap/js/bootstrap.min.js"></script>
</body>
</html>
